/*
 * MeleeDamageObject.h
 *
 * Created 9/22/2009 By Johnny Huynh
 *
 * Version 00.00.01 9/22/2009
 *
 * Copyright Information:
 * All content copyright  2009 Johnny Huynh. All rights reserved.
 */
 
 #ifndef MELEE_DAMAGE_OBJECT_H
 #define MELEE_DAMAGE_OBJECT_H
 
 template <typename T> class MeleeDamageObject;
 
 #include "CollisionHandlerEventNode.h"
 #include "DamageObject.h"
 #include "RotateSegmentMovementInfo.h"
 
 #include "global.h"
 
 /**
  * Class specification for MeleeDamageObject
  * A MeleeDamageObject is a damage object for melee attacks
  */
 template <typename T>
 class MeleeDamageObject : virtual public DamageObject<T>
 {
 // Data Members
 private:
    MovementInfoCollection<T> _movement_info_collection;
    //PT(MovementInfo<T>) _movement_info_Ptr;
 
 // Local Functions
 public:
    MeleeDamageObject( const std::string& name, const T& damage,
                       CollisionSegment* collision_segment_Ptr,
                       const VECTOR3_TYPE& acceleration = VECTOR3_TYPE( ZERO, ZERO, ZERO ), 
                       const VECTOR3_TYPE& velocity = VECTOR3_TYPE( ZERO, ZERO, ZERO ),
                       const VECTOR3_TYPE& begin_point = VECTOR3_TYPE( ZERO, ZERO, ZERO ),
                       const T distance = ONE, const double duration = 0.0 ); 
    MeleeDamageObject( const std::string& name, const T& damage, const EffectInfoCollection<T>& effect_info_collection,
                       CollisionSegment* collision_segment_Ptr,
                       const VECTOR3_TYPE& acceleration = VECTOR3_TYPE( ZERO, ZERO, ZERO ), 
                       const VECTOR3_TYPE& velocity = VECTOR3_TYPE( ZERO, ZERO, ZERO ),
                       const VECTOR3_TYPE& begin_point = VECTOR3_TYPE( ZERO, ZERO, ZERO ),
                       const T distance = ONE, const double duration = 0.0 ); 
    MeleeDamageObject( const MeleeDamageObject<T>& melee_dmg_obj );
    virtual ~MeleeDamageObject();
    inline MeleeDamageObject<T>& operator=( const MeleeDamageObject<T>& melee_dmg_obj );
    virtual void reparent_to(Object<T>& other, double time_action_will_begin = 0.0, int sort = 0,
                   Thread* current_thread = Thread::get_current_thread());
    virtual void wrt_reparent_to(Object<T>& other, double time_action_will_begin = 0.0, int sort = 0,
                   Thread* current_thread = Thread::get_current_thread());
    
    // overloaded functions (NodePath)
    /*static void init_type() {
                                std::string template_type( typeid( T ).name() );
                                register_type(_type_handle, "MeleeDamageObject<" + template_type + ">" );
                            }*/
 
 // Private Functions
 private:
    
 // Public Static Functions
 public:
    
 };
 
 /** LOCAL FUNCTIONS **/
 
 /**
  * Constructor
  * distance only effects the acceleration and velocity
  */
 template <typename T>
 MeleeDamageObject<T>::MeleeDamageObject( const std::string& name, const T& damage,
                                          CollisionSegment* collision_segment_Ptr,
                                          const VECTOR3_TYPE& acceleration, 
                                          const VECTOR3_TYPE& velocity,
                                          const VECTOR3_TYPE& begin_point,
                                          const T distance, const double duration )
                      : DamageObject<T>( name, damage )
 {
    PT(RotateSegmentMovementInfo<T>) rotate_segment_movement_info_Ptr( 
                                new RotateSegmentMovementInfo<T>( collision_segment_Ptr, acceleration, 
                                                               velocity, begin_point, distance, duration ) );
    _movement_info_collection.add( rotate_segment_movement_info_Ptr );
 }
 
 /**
  * Alternative Constructor
  * distance only effects the acceleration and velocity
  */
 template <typename T>
 MeleeDamageObject<T>::MeleeDamageObject( const std::string& name, const T& damage, 
                                          const EffectInfoCollection<T>& effect_info_collection,
                                          CollisionSegment* collision_segment_Ptr,
                                          const VECTOR3_TYPE& acceleration, 
                                          const VECTOR3_TYPE& velocity,
                                          const VECTOR3_TYPE& begin_point,
                                          const T distance, const double duration )
                      : DamageObject<T>( name, damage, effect_info_collection )
 {
    PT(RotateSegmentMovementInfo<T>) rotate_segment_movement_info_Ptr( 
                                new RotateSegmentMovementInfo<T>( collision_segment_Ptr, acceleration, 
                                                               velocity, begin_point, distance, duration ) );
    _movement_info_collection.add( rotate_segment_movement_info_Ptr );
 }
 
 /**
  * Copy Constructor
  */
 template <typename T>
 MeleeDamageObject<T>::MeleeDamageObject( const MeleeDamageObject<T>& melee_dmg_obj )
                      : DamageObject<T>( melee_dmg_obj ),
                        _movement_info_collection( melee_dmg_obj._movement_info_collection )
 {
    
 }
 
 /**
  * Destructor
  */
 template <typename T>
 MeleeDamageObject<T>::~MeleeDamageObject()
 {
    
 }
 
 /**
  * operator=() copies the content of the specified MeleeDamageObject to this MeleeDamageObject.
  *
  * @param (const MeleeDamageObject<T>& melee_dmg_obj )
  * @return MeleeDamageObject<T>&
  */
 template <typename T>
 inline MeleeDamageObject<T>& MeleeDamageObject<T>::operator=( const MeleeDamageObject<T>&  melee_dmg_obj )
 {
    DamageObject<T>::operator=( static_cast< DamageObject<T> >( melee_dmg_obj ) );
    _movement_info_collection = melee_dmg_obj._movement_info_collection;
    
    return *this;
 }
 
 template <typename T>
 void MeleeDamageObject<T>::reparent_to( Object<T>& other, double time_action_will_begin, int sort, Thread* current_thread )
 {
    Object<T>::reparent_to( other, sort, current_thread );
    
    PT(MoveInfo<T>) move_info_Ptr( new MoveInfo<T>( _movement_info_collection, time_action_will_begin ) );
    PT(ActionTask<T>) action_task_Ptr( new ActionTask<T>( &other, move_info_Ptr ) );
    action_task_Ptr->add_to_task_manager();
 }
 
 template <typename T>
 void MeleeDamageObject<T>::wrt_reparent_to( Object<T>& other, double time_action_will_begin, int sort, Thread* current_thread )
 {
    Object<T>::wrt_reparent_to( other, sort, current_thread );
    
    PT(MoveInfo<T>) move_info_Ptr( new MoveInfo<T>( _movement_info_collection, time_action_will_begin ) );
    PT(ActionTask<T>) action_task_Ptr( new ActionTask<T>( &other, move_info_Ptr ) );
    action_task_Ptr->add_to_task_manager();
 }
 
 #endif // MELEE_DAMAGE_OBJECT_H